<?php
/**
 * WPG Pro Upsell Page — Premium Feature Showcase
 *
 * @package aos-wp-governance
 * @since   1.0.0
 */
defined('ABSPATH') || exit;
?>

<div class="wrap wpg-wrap">
    <h1 class="wpg-title">
        <span class="dashicons dashicons-star-filled"></span>
        <?php esc_html_e('WP Governance Pro', 'aos-wp-governance'); ?>
        <span class="wpg-version" style="background: linear-gradient(135deg, #e85d04, #f59e0b); color: #fff;">PRO</span>
    </h1>

    <p class="wpg-subtitle">
        <?php esc_html_e('Unlock enterprise-grade AI governance with advanced monitoring, alerts, and multi-site support.', 'aos-wp-governance'); ?>
    </p>

    <!-- Hero CTA -->
    <div class="wpg-pro-hero">
        <div class="wpg-pro-hero-content">
            <h2>Take Full Control of AI on WordPress</h2>
            <p>You're already protected with the free version. <strong>Go Pro</strong> to unlock real-time alerts, advanced analytics, webhook integrations, and enterprise features that scale with your organization.</p>
            <div class="wpg-pro-hero-cta">
                <a href="https://aos-wordpress.com/pro/?utm_source=plugin&utm_medium=pro-tab&utm_campaign=upgrade" target="_blank" class="button button-primary button-hero wpg-pro-btn">
                    🚀 Upgrade to Pro — Starting at $99/year
                </a>
                <span class="wpg-pro-guarantee">🔒 30-day money-back guarantee • Instant activation</span>
            </div>
        </div>
        <div class="wpg-pro-hero-badge">
            <div class="wpg-pro-shield">🛡️</div>
            <div class="wpg-pro-badge-text">ENTERPRISE<br>READY</div>
        </div>
    </div>

    <!-- Feature Comparison -->
    <div class="wpg-card" style="margin-top: 24px;">
        <h2 style="margin-bottom: 4px;">Free vs Pro Comparison</h2>
        <p class="wpg-text-muted" style="margin-bottom: 20px;">See what you get with the Pro upgrade.</p>

        <table class="wpg-table wpg-pro-table">
            <thead>
                <tr>
                    <th style="width: 50%;">Feature</th>
                    <th style="text-align: center; width: 25%;">Free</th>
                    <th style="text-align: center; width: 25%; background: rgba(232, 93, 4, 0.06);">Pro</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><strong>Constitutional Policy Gate</strong><br><small class="wpg-text-muted">Deterministic AI governance with zero LLM</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-check">✅</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr>
                    <td><strong>6 Built-in Security Policies</strong><br><small class="wpg-text-muted">Admin creation, file editing, plugin installs, etc.</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-check">✅</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr>
                    <td><strong>Custom Policy Builder</strong><br><small class="wpg-text-muted">Visual condition builder with ability picker</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-check">✅</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr>
                    <td><strong>Immutable Audit Log</strong><br><small class="wpg-text-muted">Tamper-evident logging with checksums</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-check">✅</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr>
                    <td><strong>Simulation Testing</strong><br><small class="wpg-text-muted">Run batch test scenarios through the pipeline</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-check">✅</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr>
                    <td><strong>REST API</strong><br><small class="wpg-text-muted">Full policy and audit log API access</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-check">✅</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>

                <!-- PRO ONLY -->
                <tr class="wpg-pro-row">
                    <td><strong>📧 Real-Time Email Alerts</strong><br><small class="wpg-text-muted">Get notified instantly when a high-risk action is denied</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-lock">🔒</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr class="wpg-pro-row">
                    <td><strong>🔔 Webhook Integrations</strong><br><small class="wpg-text-muted">Send governance events to Slack, Discord, Teams, or any webhook URL</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-lock">🔒</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr class="wpg-pro-row">
                    <td><strong>📊 Advanced Analytics Dashboard</strong><br><small class="wpg-text-muted">Trend charts, agent behavior analysis, deny rate tracking over time</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-lock">🔒</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr class="wpg-pro-row">
                    <td><strong>🤖 Agent Profiles</strong><br><small class="wpg-text-muted">Per-agent trust levels, permissions, and behavioral tracking</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-lock">🔒</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr class="wpg-pro-row">
                    <td><strong>🌐 Multi-Site Support</strong><br><small class="wpg-text-muted">Centralized governance across your entire WordPress network</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-lock">🔒</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr class="wpg-pro-row">
                    <td><strong>📦 Policy Import / Export</strong><br><small class="wpg-text-muted">Share policy configurations across sites with JSON import/export</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-lock">🔒</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr class="wpg-pro-row">
                    <td><strong>⏰ Scheduled Policies</strong><br><small class="wpg-text-muted">Time-based rules: restrict AI actions to business hours only</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-lock">🔒</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr class="wpg-pro-row">
                    <td><strong>🔐 IP Allowlisting</strong><br><small class="wpg-text-muted">Restrict AI agent access by IP address or range</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-lock">🔒</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr class="wpg-pro-row">
                    <td><strong>📈 Audit Log Export (CSV/JSON)</strong><br><small class="wpg-text-muted">Download audit logs for compliance, reporting, and archival</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-lock">🔒</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
                <tr class="wpg-pro-row">
                    <td><strong>🎯 Priority Support</strong><br><small class="wpg-text-muted">Direct email support with 24-hour response guarantee</small></td>
                    <td style="text-align: center;"><span class="wpg-pro-lock">🔒</span></td>
                    <td style="text-align: center; background: rgba(232, 93, 4, 0.03);"><span class="wpg-pro-check">✅</span></td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Pricing -->
    <div class="wpg-pro-pricing">
        <div class="wpg-pro-plan">
            <h3>Single Site</h3>
            <div class="wpg-pro-price">$99<span>/year</span></div>
            <ul>
                <li>✅ All Pro features</li>
                <li>✅ 1 site license</li>
                <li>✅ 1 year of updates</li>
                <li>✅ Email support</li>
            </ul>
            <a href="https://aos-wordpress.com/pro/?plan=single&utm_source=plugin&utm_medium=pro-tab" target="_blank" class="button button-primary wpg-pro-plan-btn">Get Single Site</a>
        </div>
        <div class="wpg-pro-plan wpg-pro-plan-featured">
            <div class="wpg-pro-popular">MOST POPULAR</div>
            <h3>5 Sites</h3>
            <div class="wpg-pro-price">$249<span>/year</span></div>
            <ul>
                <li>✅ All Pro features</li>
                <li>✅ 5 site licenses</li>
                <li>✅ 1 year of updates</li>
                <li>✅ Priority support</li>
                <li>✅ Multi-site support</li>
            </ul>
            <a href="https://aos-wordpress.com/pro/?plan=five&utm_source=plugin&utm_medium=pro-tab" target="_blank" class="button button-primary wpg-pro-plan-btn">Get 5 Sites</a>
        </div>
        <div class="wpg-pro-plan">
            <h3>Unlimited</h3>
            <div class="wpg-pro-price">$499<span>/year</span></div>
            <ul>
                <li>✅ All Pro features</li>
                <li>✅ Unlimited sites</li>
                <li>✅ Lifetime updates</li>
                <li>✅ Priority support</li>
                <li>✅ White-label option</li>
            </ul>
            <a href="https://aos-wordpress.com/pro/?plan=unlimited&utm_source=plugin&utm_medium=pro-tab" target="_blank" class="button button-primary wpg-pro-plan-btn">Get Unlimited</a>
        </div>
    </div>

    <!-- Bottom CTA -->
    <div class="wpg-card" style="text-align: center; padding: 32px;">
        <h2>Questions? We're Here to Help.</h2>
        <p class="wpg-text-muted" style="margin-bottom: 16px;">Contact us at <a href="mailto:support@aos-wordpress.com">support@aos-wordpress.com</a> or visit our website for more information.</p>
        <a href="https://aos-wordpress.com/?utm_source=plugin&utm_medium=pro-tab" target="_blank" class="button">Visit aos-wordpress.com →</a>
    </div>
</div>
